import java.awt.Color;
import java.awt.Graphics;

public class Ticker extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean CanBeDeletedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return false;
	}
	@Override
	public boolean CanBeMovedByUser()
	{
		return false;
	}

	@Override
	public boolean CanBeSelectedByUser()
	{
		return false;
	}
	// end of DrawObject abilities
	
	private final int TickerTextWidth = 100;
	private char[] TickerText = new char[TickerTextWidth];

	public Ticker()
	{
		Clear();
	}

	public void Clear()
	{
		for (int m = 0; m < TickerTextWidth; m++)
			TickerText[m] = ' ';
	}

	@Override
	public void Draw(Graphics g)
	{
		// grid lines x/y distance hard-coded to 50 pixels, all objects are aligned to this raster

		SetColor(g, Color.BLACK);
		String TickerTextString = new String(TickerText);
		g.setFont(GetDefaultFont());
		int LetterWidth = g.getFontMetrics().getWidths()[32]; // get width of space char
		DrawString(g, TickerTextString, MainWindow.MainWindowSizeX / 2 - (LetterWidth * TickerTextWidth) / 2, 50);
	}

	public void ReceiveString(String TickerTextPart)
	{
		ShiftTickerText(TickerTextPart.length());

		for (int m = 0; m < TickerTextPart.length(); m++)
			TickerText[TickerTextWidth - TickerTextPart.length() + m] = TickerTextPart.charAt(m);
	}

	private void ShiftTickerText(int ShiftAmount)
	{ // always shift to the LEFT, ShiftAmount MUST be positive

		if (ShiftAmount <= 0)
		{
			System.out.println("warning in Ticker.ShiftTickerText(): passed value not useful!");
			return;
		}

		for (int m = 0; m < TickerTextWidth - ShiftAmount; m++)
			TickerText[m] = TickerText[m + ShiftAmount];
		for (int m = 0; m < ShiftAmount; m++)
			TickerText[TickerTextWidth - ShiftAmount + m] = ' ';

		return;
	}

	public void Tick()
	{
		ShiftTickerText(1);
	}
}
